//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit3.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm3 *Form3;
//---------------------------------------------------------------------------
__fastcall TForm3::TForm3(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm3::Button1Click(TObject *Sender)
{
    ModalResult = mrOk;
}
//---------------------------------------------------------------------------
void __fastcall TForm3::showinfo(char *fcd_file)
{
	FILE *in;

	FCD fcd;

	int i;

	static const char type[][11] = {
		"Unknown", "ISO (2048)", "RAW (2352)", "", "DA  (2352)",
	};

    in = fopen(fcd_file, "rb");
    if(in == NULL){
        open_file_error(fcd_file);
        Close();
	}
    fcd.path = fcd_file;

	if(!read_fcd_info(in, &fcd)){
        read_fcd_info_error(fcd_file);
		fclose(in);
		Close();
	}

	fcd_view->Lines->Add(Format("Description: %s", ARRAYOFCONST((fcd.cdi.desc))));
	fcd_view->Lines->Add(Format("Last Track:  %d", ARRAYOFCONST((fcd.cdi.num_of_track))));
	fcd_view->Lines->Add(Format("Total MSF:   %.2d:%.2d:%.2d", ARRAYOFCONST(((int)fcd.cdi.total.m, (int)fcd.cdi.total.s, (int)fcd.cdi.total.f))));
	fcd_view->Lines->Add("");
    fcd_view->Lines->Add("  Track  Start LBN  Block Num  Post Gap  Type");
    fcd_view->Lines->Add("  -----  ---------  ---------  --------  -----------");

	for(i=0;i<fcd.cdi.num_of_track;i++){
		fcd_view->Lines->Add(Format("     %.2d     %6d     %6d    %6d  %s",
			ARRAYOFCONST((i+1, (int)fcd.cdi.ti[i].start, (int)fcd.cdi.ti[i].num_of_block, (int)fcd.cdi.ti[i].post_gap, type[fcd.cdi.ti[i].type]))));
	}
	fcd_view->Lines->Add("  -----  ---------  ---------  --------  -----------");

    fclose(in);

    return;
}
//---------------------------------------------------------------------------
void __fastcall TForm3::WMSysCommand(TWMSysCommand& Msg)
{
    if ( (Msg.CmdType & 0xfff0) == SC_MINIMIZE ){
        Application->Minimize();
    }else{
        TForm::Dispatch(&Msg);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm3::set_language()
{
    LANGID id;

    id = GetUserDefaultLangID();

    if(id == 0x0411){
        language = LANGUAGE_TYPE_JAPANESE;
    }else{
        Font->Charset = ANSI_CHARSET;
        Font->Name = "Arial";

        Caption = "FCD Infomation";
        Button1->Caption = "OK";

        language = LANGUAGE_TYPE_ENGLISH;
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm3::open_file_error(char *path)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s J܂ł", ARRAYOFCONST((path)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("Can't open %s", ARRAYOFCONST((path)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm3::read_fcd_info_error(char *path)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s  FCD t@Cł͂܂", ARRAYOFCONST((path)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("%s is not FCD file", ARRAYOFCONST((path)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm3::FormCreate(TObject *Sender)
{
    set_language();
}
//---------------------------------------------------------------------------

